
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x0") # milligrams of calcium
    x1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x1") # milligrams of magnesium
    x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x2") # milligrams of vitamin B7
    x3 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x3") # milligrams of vitamin B2


    # Set objective function
    m.setObjective(5*x0 + 8*x1 + 7*x2 + 6*x3, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(25*x0 + 6*x1 + 16*x2 + 8*x3 <= 162)
    m.addConstr(26*x0 + 20*x1 + 26*x2 + 24*x3 <= 551)
    m.addConstr(3*x0 + 22*x1 + 19*x2 + 18*x3 <= 557)
    m.addConstr(25*x0 + 16*x2 >= 22)
    m.addConstr(25*x0 + 6*x1 >= 18)
    m.addConstr(6*x1 + 16*x2 >= 14)
    m.addConstr(26*x0 + 20*x1 + 26*x2 >= 107)
    m.addConstr(3*x0 + 22*x1 >= 80)
    m.addConstr(22*x1 + 19*x2 + 18*x3 >= 98)
    m.addConstr(3*x0 + 22*x1 + 18*x3 >= 98)
    m.addConstr(22*x1 + 19*x2 + 18*x3 >= 104)
    m.addConstr(3*x0 + 22*x1 + 18*x3 >= 104)
    m.addConstr(6*x1 + 8*x3 <= 102)
    m.addConstr(25*x0 + 8*x3 <= 149)
    m.addConstr(25*x0 + 16*x2 + 8*x3 <= 43)
    m.addConstr(25*x0 + 6*x1 + 16*x2 <= 84)
    m.addConstr(25*x0 + 6*x1 + 8*x3 <= 96)
    m.addConstr(25*x0 + 6*x1 + 16*x2 + 8*x3 <= 96)
    m.addConstr(20*x1 + 24*x3 <= 276)
    m.addConstr(20*x1 + 26*x2 <= 241)
    m.addConstr(20*x1 + 26*x2 + 24*x3 <= 155)
    m.addConstr(26*x0 + 20*x1 + 24*x3 <= 548)
    m.addConstr(26*x0 + 20*x1 + 26*x2 <= 329)
    m.addConstr(26*x0 + 26*x2 + 24*x3 <= 455)
    m.addConstr(26*x0 + 20*x1 + 26*x2 + 24*x3 <= 455)
    m.addConstr(3*x0 + 19*x2 <= 495)
    m.addConstr(3*x0 + 22*x1 <= 279)
    m.addConstr(22*x1 + 19*x2 + 18*x3 <= 513)
    m.addConstr(3*x0 + 19*x2 + 18*x3 <= 342)
    m.addConstr(3*x0 + 22*x1 + 19*x2 <= 201)
    m.addConstr(3*x0 + 22*x1 + 19*x2 + 18*x3 <= 201)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
