
import gurobipy as gp

# Create a new model
m = gp.Model("vitamin_optimization")

# Create variables
vitamin_k = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_k")
vitamin_b5 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b5")
vitamin_a = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_a")


# Set objective function
m.setObjective(3*vitamin_k*vitamin_b5 + 3*vitamin_b5**2 + 2*vitamin_b5 + 3*vitamin_a, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(5*vitamin_k + 4*vitamin_b5 + 14*vitamin_a <= 132, "c0")
m.addConstr(17*vitamin_k + 10*vitamin_b5 + 5*vitamin_a <= 129, "c1")
m.addConstr(14*vitamin_k + 17*vitamin_b5 + 4*vitamin_a <= 116, "c2")
m.addConstr(10*vitamin_k + 16*vitamin_b5 + 6*vitamin_a <= 231, "c3")
m.addConstr(4*vitamin_b5 + 14*vitamin_a >= 42, "c4")
m.addConstr(5*vitamin_k + 14*vitamin_a >= 38, "c5")
m.addConstr(5*vitamin_k + 4*vitamin_b5 + 14*vitamin_a >= 32, "c6")
m.addConstr(17*vitamin_k**2 + 5*vitamin_a**2 >= 30, "c7")
m.addConstr(14*vitamin_k**2 + 17*vitamin_b5**2 + 4*vitamin_a**2 >= 27, "c8")
m.addConstr(10*vitamin_k + 16*vitamin_b5 + 6*vitamin_a >= 59, "c9")
m.addConstr(4*vitamin_b5 + 14*vitamin_a <= 70, "c10")
m.addConstr(5*vitamin_k + 4*vitamin_b5 + 14*vitamin_a <= 70, "c11")
m.addConstr(10*vitamin_b5**2 + 5*vitamin_a**2 <= 105, "c12")
m.addConstr(17*vitamin_k + 10*vitamin_b5 <= 121, "c13")
m.addConstr(17*vitamin_k + 10*vitamin_b5 + 5*vitamin_a <= 121, "c14")
m.addConstr(14*vitamin_k + 17*vitamin_b5 <= 68, "c15")
m.addConstr(14*vitamin_k + 4*vitamin_a <= 72, "c16")
m.addConstr(14*vitamin_k + 17*vitamin_b5 + 4*vitamin_a <= 72, "c17")
m.addConstr(10*vitamin_k + 6*vitamin_a <= 85, "c18")
m.addConstr(10*vitamin_k + 16*vitamin_b5 <= 102, "c19")
m.addConstr(10*vitamin_k + 16*vitamin_b5 + 6*vitamin_a <= 102, "c20")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('vitamin_k:', vitamin_k.x)
    print('vitamin_b5:', vitamin_b5.x)
    print('vitamin_a:', vitamin_a.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

