
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define variables
x0 = m.addVar(name="x0", lb=0)  # milligrams of vitamin K
x1 = m.addVar(name="x1", lb=0)  # milligrams of vitamin B5
x2 = m.addVar(name="x2", lb=0)  # milligrams of vitamin A

# Objective function
m.setObjective(3*x0*x1 + 3*x1**2 + 2*x1 + 3*x2, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(5*x0 == 5)
m.addConstr(17*x0 == 17)
m.addConstr(14*x0 == 14)
m.addConstr(10*x0 == 10)

m.addConstr(4*x1 == 4)
m.addConstr(10*x1 == 10)
m.addConstr(17*x1 == 17)
m.addConstr(16*x1 == 16)

m.addConstr(14*x2 == 14)
m.addConstr(5*x2 == 5)
m.addConstr(4*x2 == 4)
m.addConstr(6*x2 == 6)

m.addConstr(4*x1 + 14*x2 >= 42)
m.addConstr(5*x0 + 14*x2 >= 38)
m.addConstr(5*x0 + 4*x1 + 14*x2 >= 32)
m.addConstr(17**2*x0**2 + 5**2*x2**2 >= 30)
m.addConstr(14**2*x0**2 + 17**2*x1**2 + 4**2*x2**2 >= 27)
m.addConstr(10*x0 + 16*x1 + 6*x2 >= 59)
m.addConstr(4*x1 + 14*x2 <= 70)
m.addConstr(5*x0 + 4*x1 + 14*x2 <= 70)
m.addConstr(10**2*x1**2 + 5**2*x2**2 <= 105)
m.addConstr(17*x0 + 10*x1 <= 121)
m.addConstr(17*x0 + 10*x1 + 5*x2 <= 121)
m.addConstr(14*x0 + 17*x1 <= 68)
m.addConstr(14*x0 + 4*x2 <= 72)
m.addConstr(14*x0 + 17*x1 + 4*x2 <= 72)
m.addConstr(10*x0 + 6*x2 <= 85)
m.addConstr(10*x0 + 16*x1 <= 102)
m.addConstr(10*x0 + 16*x1 + 6*x2 <= 102)

# Solve the model
m.optimize()

# Print the solution
print("Objective: ", m.objVal)
print("x0: ", x0.varValue)
print("x1: ", x1.varValue)
print("x2: ", x2.varValue)
