
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x = m.addVars(4, lb=0, vtype=gp.GRB.CONTINUOUS, name=["Jean", "Peggy", "Bobby", "Laura"])

    # Set objective function
    m.setObjective(4.44 * x[0] + 5.12 * x[1] + 2.1 * x[2] + 7.6 * x[3], gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(9 * x[1] + 16 * x[3] >= 56)
    m.addConstr(15 * x[2] + 16 * x[3] >= 59)
    m.addConstr(5 * x[2] + 2 * x[3] >= 13)
    m.addConstr(13 * x[0] + 5 * x[2] >= 34)
    m.addConstr(16 * x[1] + 5 * x[2] >= 26)
    m.addConstr(13 * x[0] + 16 * x[1] + 5 * x[2] >= 29)
    m.addConstr(13 * x[0] + 16 * x[1] + 2 * x[3] >= 29)
    m.addConstr(16 * x[1] + 5 * x[2] + 2 * x[3] >= 29)
    m.addConstr(13 * x[0] + 16 * x[1] + 5 * x[2] >= 35)
    m.addConstr(13 * x[0] + 16 * x[1] + 2 * x[3] >= 35)
    m.addConstr(16 * x[1] + 5 * x[2] + 2 * x[3] >= 35)
    m.addConstr(13 * x[0] + 16 * x[1] + 5 * x[2] >= 35)
    m.addConstr(13 * x[0] + 16 * x[1] + 2 * x[3] >= 35)
    m.addConstr(16 * x[1] + 5 * x[2] + 2 * x[3] >= 35)
    m.addConstr(10 * x[0] + 8 * x[2] + 10 * x[3] >= 42)
    m.addConstr(5 * x[1] + 8 * x[2] + 10 * x[3] >= 42)
    m.addConstr(10 * x[0] + 5 * x[1] + 8 * x[2] >= 42)
    m.addConstr(10 * x[0] + 8 * x[2] + 10 * x[3] >= 34)
    m.addConstr(5 * x[1] + 8 * x[2] + 10 * x[3] >= 34)
    m.addConstr(10 * x[0] + 5 * x[1] + 8 * x[2] >= 34)
    m.addConstr(10 * x[0] + 8 * x[2] + 10 * x[3] >= 28)
    m.addConstr(5 * x[1] + 8 * x[2] + 10 * x[3] >= 28)
    m.addConstr(10 * x[0] + 5 * x[1] + 8 * x[2] >= 28)
    m.addConstr(9 * x[0] + 9 * x[1] <= 76)
    m.addConstr(9 * x[0] + 15 * x[2] <= 192)
    m.addConstr(9 * x[1] + 16 * x[3] <= 63)
    m.addConstr(9 * x[0] + 9 * x[1] + 15 * x[2] + 16 * x[3] <= 63)
    m.addConstr(16 * x[1] + 5 * x[2] <= 96)
    m.addConstr(13 * x[0] + 2 * x[3] <= 78)
    m.addConstr(16 * x[1] + 2 * x[3] <= 142)
    m.addConstr(13 * x[0] + 16 * x[1] + 5 * x[2] + 2 * x[3] <= 142)
    m.addConstr(10 * x[0] + 5 * x[1] <= 126)
    m.addConstr(5 * x[1] + 10 * x[3] <= 114)
    m.addConstr(10 * x[0] + 8 * x[2] <= 59)
    m.addConstr(10 * x[0] + 5 * x[1] + 10 * x[3] <= 52)
    m.addConstr(10 * x[0] + 5 * x[1] + 8 * x[2] + 10 * x[3] <= 52)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
        print('Obj: %g' % m.objVal)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
