
import gurobi

# Create a new Gurobi model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="x0", lb=0)  # hours worked by Jean
x1 = m.addVar(name="x1", lb=0)  # hours worked by Peggy
x2 = m.addVar(name="x2", lb=0)  # hours worked by Bobby
x3 = m.addVar(name="x3", lb=0)  # hours worked by Laura

# Define the objective function
m.setObjective(4.44 * x0 + 5.12 * x1 + 2.1 * x2 + 7.6 * x3, gurobi.GRB.MAXIMIZE)

# Add constraints
m.addConstr(9 * x1 + 16 * x3 >= 56)
m.addConstr(15 * x2 + 16 * x3 >= 59)
m.addConstr(5 * x2 + 2 * x3 >= 13)
m.addConstr(13 * x0 + 5 * x2 >= 34)
m.addConstr(16 * x1 + 5 * x2 >= 26)
m.addConstr(13 * x0 + 16 * x1 + 5 * x2 >= 29)
m.addConstr(13 * x0 + 16 * x1 + 2 * x3 >= 29)
m.addConstr(16 * x1 + 5 * x2 + 2 * x3 >= 29)
m.addConstr(13 * x0 + 16 * x1 + 5 * x2 >= 35)
m.addConstr(13 * x0 + 16 * x1 + 2 * x3 >= 35)
m.addConstr(16 * x1 + 5 * x2 + 2 * x3 >= 35)
m.addConstr(10 * x0 + 8 * x2 + 10 * x3 >= 42)
m.addConstr(5 * x1 + 8 * x2 + 10 * x3 >= 42)
m.addConstr(10 * x0 + 5 * x1 + 8 * x2 >= 42)
m.addConstr(10 * x0 + 8 * x2 + 10 * x3 >= 34)
m.addConstr(5 * x1 + 8 * x2 + 10 * x3 >= 34)
m.addConstr(10 * x0 + 5 * x1 + 8 * x2 >= 34)
m.addConstr(10 * x0 + 8 * x2 + 10 * x3 >= 28)
m.addConstr(5 * x1 + 8 * x2 + 10 * x3 >= 28)
m.addConstr(10 * x0 + 5 * x1 + 8 * x2 >= 28)
m.addConstr(9 * x0 + 9 * x1 <= 76)
m.addConstr(9 * x0 + 15 * x2 <= 192)
m.addConstr(9 * x1 + 16 * x3 <= 63)
m.addConstr(9 * x0 + 9 * x1 + 15 * x2 + 16 * x3 <= 63)
m.addConstr(16 * x1 + 5 * x2 <= 96)
m.addConstr(13 * x0 + 2 * x3 <= 78)
m.addConstr(16 * x1 + 2 * x3 <= 142)
m.addConstr(13 * x0 + 16 * x1 + 5 * x2 + 2 * x3 <= 142)
m.addConstr(10 * x0 + 5 * x1 <= 126)
m.addConstr(5 * x1 + 10 * x3 <= 114)
m.addConstr(10 * x0 + 8 * x2 <= 59)
m.addConstr(10 * x0 + 5 * x1 + 10 * x3 <= 52)
m.addConstr(10 * x0 + 5 * x1 + 8 * x2 + 10 * x3 <= 52)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("x0: ", x0.varValue)
    print("x1: ", x1.varValue)
    print("x2: ", x2.varValue)
    print("x3: ", x3.varValue)
else:
    print("No solution found")
