
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("resource_allocation")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.INTEGER, name="security_onions")
    x1 = m.addVar(vtype=gp.GRB.INTEGER, name="pen_testers")
    x2 = m.addVar(vtype=gp.GRB.INTEGER, name="deployed_decoys")
    x3 = m.addVar(vtype=gp.GRB.INTEGER, name="security_engineers")


    # Set objective function
    m.setObjective(9.05 * x0 + 8.15 * x1 + 7.34 * x2 + 9.75 * x3, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(2 * x0 + 11 * x1 + 9 * x2 + 6 * x3 <= 279, "power_consumption")
    m.addConstr(9 * x0 + 1 * x1 + 3 * x2 + 10 * x3 <= 200, "computational_load")
    m.addConstr(11 * x1 + 6 * x3 >= 56, "c3")
    m.addConstr(11 * x1 + 9 * x2 >= 57, "c4")
    m.addConstr(-10 * x0 + 10 * x3 >= 0, "c5")
    m.addConstr(2 * x0 + 6 * x3 <= 244, "c6")
    m.addConstr(11 * x1 + 6 * x3 <= 189, "c7")
    m.addConstr(11 * x1 + 9 * x2 <= 144, "c8")
    m.addConstr(2 * x0 + 11 * x1 <= 185, "c9")
    m.addConstr(9 * x2 + 6 * x3 <= 141, "c10")
    m.addConstr(2 * x0 + 11 * x1 + 9 * x2 + 6 * x3 <= 141, "c11")
    m.addConstr(3 * x2 + 10 * x3 <= 85, "c12")
    m.addConstr(1 * x1 + 10 * x3 <= 56, "c13")
    m.addConstr(9 * x0 + 1 * x1 + 10 * x3 <= 70, "c14")
    m.addConstr(1 * x1 + 3 * x2 + 10 * x3 <= 101, "c15")
    m.addConstr(9 * x0 + 1 * x1 + 3 * x2 <= 114, "c16")
    m.addConstr(9 * x0 + 3 * x2 + 10 * x3 <= 196, "c17")
    m.addConstr(9 * x0 + 1 * x1 + 3 * x2 + 10 * x3 <= 196, "c18")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Model is infeasible')


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
