
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="security_onions", vtype=gp.GRB.INTEGER)
x1 = m.addVar(name="pen_testers", vtype=gp.GRB.INTEGER)
x2 = m.addVar(name="deployed_decoys", vtype=gp.GRB.INTEGER)
x3 = m.addVar(name="security_engineers", vtype=gp.GRB.INTEGER)

# Define the objective function
m.setObjective(9.05*x0 + 8.15*x1 + 7.34*x2 + 9.75*x3, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(2*x0 + 11*x1 + 9*x2 + 6*x3 <= 279)
m.addConstr(9*x0 + x1 + 3*x2 + 10*x3 <= 200)
m.addConstr(x1 + x3 >= 56)
m.addConstr(11*x1 + 9*x2 >= 57)
m.addConstr(-10*x0 + 10*x3 >= 0)
m.addConstr(2*x0 + 6*x3 <= 244)
m.addConstr(11*x1 + 6*x3 <= 189)
m.addConstr(11*x1 + 9*x2 <= 144)
m.addConstr(2*x0 + 11*x1 <= 185)
m.addConstr(9*x2 + 6*x3 <= 141)
m.addConstr(2*x0 + 11*x1 + 9*x2 + 6*x3 <= 141)
m.addConstr(3*x2 + 10*x3 <= 85)
m.addConstr(x1 + 10*x3 <= 56)
m.addConstr(9*x0 + x1 + 10*x3 <= 70)
m.addConstr(x1 + 3*x2 + 10*x3 <= 101)
m.addConstr(9*x0 + x1 + 3*x2 <= 114)
m.addConstr(9*x0 + 3*x2 + 10*x3 <= 196)
m.addConstr(9*x0 + x1 + 3*x2 + 10*x3 <= 196)

# Optimize the model
m.optimize()

# Print the solution
print("Objective: ", m.objVal)
print("Security Onions: ", x0.varValue)
print("Pen Testers: ", x1.varValue)
print("Deployed Decoys: ", x2.varValue)
print("Security Engineers: ", x3.varValue)

# Symbolic representation
print("Symbolic Representation:")
print("Variables: ")
print([('x0', 'security onions'), ('x1', 'pen testers'), ('x2', 'deployed decoys'), ('x3', 'security engineers')])
print("Objective Function: 9.05x0 + 8.15x1 + 7.34x2 + 9.75x3")
print("Constraints: ")
print("1. 2x0 + 11x1 + 9x2 + 6x3 <= 279")
print("2. 9x0 + x1 + 3x2 + 10x3 <= 200")
print("3. x1 + x3 >= 56")
print("4. 11x1 + 9x2 >= 57")
print("5. -10x0 + 10x3 >= 0")
print("6. 2x0 + 6x3 <= 244")
print("7. 11x1 + 6x3 <= 189")
print("8. 11x1 + 9x2 <= 144")
print("9. 2x0 + 11x1 <= 185")
print("10. 9x2 + 6x3 <= 141")
print("11. 2x0 + 11x1 + 9x2 + 6x3 <= 141")
print("12. 3x2 + 10x3 <= 85")
print("13. x1 + 10x3 <= 56")
print("14. 9x0 + x1 + 10x3 <= 70")
print("15. x1 + 3x2 + 10x3 <= 101")
print("16. 9x0 + x1 + 3x2 <= 114")
print("17. 9x0 + 3x2 + 10x3 <= 196")
print("18. 9x0 + x1 + 3x2 + 10x3 <= 196")

# JSON output
import json
json_output = {
    'sym_variables': [('x0', 'security onions'), ('x1', 'pen testers'), ('x2', 'deployed decoys'), ('x3', 'security engineers')],
    'objective_function': '9.05x0 + 8.15x1 + 7.34x2 + 9.75x3',
    'constraints': [
        '2x0 + 11x1 + 9x2 + 6x3 <= 279',
        '9x0 + x1 + 3x2 + 10x3 <= 200',
        'x1 + x3 >= 56',
        '11x1 + 9x2 >= 57',
        '-10x0 + 10x3 >= 0',
        '2x0 + 6x3 <= 244',
        '11x1 + 6x3 <= 189',
        '11x1 + 9x2 <= 144',
        '2x0 + 11x1 <= 185',
        '9x2 + 6x3 <= 141',
        '2x0 + 11x1 + 9x2 + 6x3 <= 141',
        '3x2 + 10x3 <= 85',
        'x1 + 10x3 <= 56',
        '9x0 + x1 + 10x3 <= 70',
        'x1 + 3x2 + 10x3 <= 101',
        '9x0 + x1 + 3x2 <= 114',
        '9x0 + 3x2 + 10x3 <= 196',
        '9x0 + x1 + 3x2 + 10x3 <= 196'
    ]
}
print(json.dumps(json_output))
