
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("nutrition_optimization")

    # Create variables
    fiber = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="fiber")
    vitamin_b5 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="vitamin_b5")


    # Set objective function
    m.setObjective(1 * fiber + 2 * vitamin_b5, GRB.MINIMIZE)

    # Add constraints
    m.addConstr(4 * fiber + 4 * vitamin_b5 >= 1, "cognitive_performance_min")
    m.addConstr(3 * fiber + 4 * vitamin_b5 >= 6, "kidney_support_min")
    m.addConstr(1 * fiber + 3 * vitamin_b5 >= 6, "digestive_support_min")
    m.addConstr(-2 * fiber + 4 * vitamin_b5 >= 0, "fiber_vitamin_ratio")
    m.addConstr(4 * fiber + 4 * vitamin_b5 <= 11, "cognitive_performance_max")
    m.addConstr(3 * fiber + 4 * vitamin_b5 <= 26, "kidney_support_max")
    m.addConstr(1 * fiber + 3 * vitamin_b5 <= 22, "digestive_support_max")


    # Optimize model
    m.optimize()

    # Print results
    if m.status == GRB.OPTIMAL:
        print(f"Optimal objective value: {m.objVal}")
        print(f"Grams of fiber: {fiber.x}")
        print(f"Milligrams of vitamin B5: {vitamin_b5.x}")
    elif m.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization terminated with status {m.status}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
