
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(name="grams_of_fiber", lb=-GRB.INFINITY)  # Allowed to be non-integer
x2 = m.addVar(name="milligrams_of_vitamin_B5", lb=-GRB.INFINITY)  # Allowed to be non-integer

# Objective function
m.setObjective(1*x1 + 2*x2, GRB.MINIMIZE)

# Constraints
m.addConstr(4*x1 + 4*x2 >= 1, name="cognitive_performance_index_min")
m.addConstr(3*x1 + 4*x2 >= 6, name="kidney_support_index_min")
m.addConstr(x1 + 3*x2 >= 6, name="digestive_support_index_min")
m.addConstr(-2*x1 + 4*x2 >= 0, name="additional_constraint_1")
m.addConstr(4*x1 + 4*x2 <= 11, name="cognitive_performance_index_max")
m.addConstr(3*x1 + 4*x2 <= 26, name="kidney_support_index_max")
m.addConstr(x1 + 3*x2 <= 22, name="digestive_support_index_max")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"grams_of_fiber: {x1.x}")
    print(f"milligrams_of_vitamin_B5: {x2.x}")
else:
    print("No optimal solution found")
