
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="grams_of_fiber", lb=0)  # Assuming non-negative
    x2 = model.addVar(name="milligrams_of_vitamin_B5", lb=0)  # Assuming non-negative

    # Define the objective function
    model.setObjective(1 * x1 + 2 * x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(4 * x1 + 4 * x2 >= 1, name="cognitive_performance_index_min")
    model.addConstr(3 * x1 + 4 * x2 >= 6, name="kidney_support_index_min")
    model.addConstr(1 * x1 + 3 * x2 >= 6, name="digestive_support_index_min")
    model.addConstr(-2 * x1 + 4 * x2 >= 0, name="vitamin_B5_support")
    model.addConstr(4 * x1 + 4 * x2 <= 11, name="cognitive_performance_index_max")
    model.addConstr(3 * x1 + 4 * x2 <= 26, name="kidney_support_index_max")
    model.addConstr(1 * x1 + 3 * x2 <= 22, name="digestive_support_index_max")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Grams of fiber: {x1.varValue}")
        print(f"Milligrams of vitamin B5: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
