
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    x = model.addVars(4, vtype=GRB.INTEGER, name=["Dale", "Peggy", "Paul", "John"])


    # Set objective function
    obj = x[0]*x[1] + x[0]*x[2] + 3*x[0]*x[3] + 4*x[1]**2 + 8*x[1]*x[2] + 6*x[1]*x[3] + 7*x[2]*x[3] + x[3]**2 + 4*x[0] + 8*x[1] + 2*x[2] + 2*x[3]
    model.setObjective(obj, GRB.MINIMIZE)

    # Add constraints
    model.addConstr(11*x[2] + 4*x[3] >= 25, "c0")
    model.addConstr(5*x[0]**2 + 11*x[2]**2 >= 17, "c1")
    model.addConstr(8*x[1] + 4*x[3] >= 25, "c2")
    model.addConstr(5*x[0] + 4*x[3] >= 10, "c3")
    model.addConstr(5*x[0] + 8*x[1] + 11*x[2] >= 24, "c4")
    model.addConstr(5*x[0] + 8*x[1] + 11*x[2] + 4*x[3] >= 24, "c5")
    model.addConstr(2*x[1] + 9*x[3] >= 31, "c6")
    model.addConstr(7*x[0] + 9*x[3] >= 16, "c7")
    model.addConstr(7*x[0] + 2*x[1] + 2*x[2] >= 31, "c8")
    model.addConstr(7*x[0] + 2*x[1] + 2*x[2] + 9*x[3] >= 31, "c9")
    model.addConstr(2*x[1] + 2*x[2] <= 80, "c10")
    model.addConstr(7*x[0] + 9*x[3] <= 67, "c11")
    model.addConstr(7*x[0]**2 + 2*x[2]**2 + 9*x[3]**2 <= 55, "c12")
    model.addConstr(7*x[0] + 2*x[1] + 2*x[2] <= 53, "c13")
    model.addConstr(2*x[1] + 2*x[2] + 9*x[3] <= 88, "c14")


    # Optimize model
    model.optimize()

    if model.status == GRB.OPTIMAL:
        for v in model.getVars():
            print(f'{v.varName}: {v.x}')
        print(f'Obj: {model.objVal}')
    elif model.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {model.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
