
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x1 = m.addVar(name='bananas', lb=0)
x2 = m.addVar(name='chicken_drumsticks', lb=0)
x3 = m.addVar(name='apples', lb=0)
x4 = m.addVar(name='blueberry_pies', lb=0)
x5 = m.addVar(name='cheeseburgers', lb=0)

# Objective function
m.setObjective(6.1*x1 + 6.75*x2 + 7.83*x3 + 3.88*x4 + 9.87*x5, gurobi.GRB.MINIMIZE)

# Constraints
m.addConstr(9*x1 + 2*x2 + 26*x3 + 12*x4 + 4*x5 <= 187)
m.addConstr(9*x1 + 5*x2 + 9*x3 + 3*x4 + 21*x5 <= 267)
m.addConstr(2*x2 + 26*x3 >= 13)
m.addConstr(9*x1 + 12*x4 >= 28)
m.addConstr(9*x1 + 2*x2 >= 29)
m.addConstr(9*x1 + 26*x3 >= 31)
m.addConstr(26*x3 + 12*x4 >= 13)
m.addConstr(26*x3 + 12*x4 + 4*x5 >= 18)
m.addConstr(9*x1 + 2*x2 + 12*x4 >= 18)
m.addConstr(9*x1 + 12*x4 + 4*x5 >= 18)
m.addConstr(9*x1 + 26*x3 + 4*x5 >= 18)
m.addConstr(2*x2 + 26*x3 + 12*x4 >= 18)
m.addConstr(26*x3 + 12*x4 + 4*x5 >= 26)
m.addConstr(5*x2 + 21*x5 >= 27)
m.addConstr(9*x1 + 9*x3 >= 23)
m.addConstr(9*x3 + 3*x4 >= 23)
m.addConstr(9*x1 + 3*x4 >= 51)
m.addConstr(-3*x2 + x5 >= 0)
m.addConstr(2*x2 + 26*x3 + 12*x4 <= 50)
m.addConstr(9*x1 + 26*x3 + 12*x4 <= 50)
m.addConstr(9*x3 + 21*x5 <= 146)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print('Objective: ', m.objVal)
    print('Bananas: ', x1.varValue)
    print('Chicken drumsticks: ', x2.varValue)
    print('Apples: ', x3.varValue)
    print('Blueberry pies: ', x4.varValue)
    print('Cheeseburgers: ', x5.varValue)
else:
    print('No optimal solution found')
