
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="scissors", vtype=gurobi.GRB.INTEGER)
    x1 = model.addVar(name="smoke detectors", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="hole punches", vtype=gurobi.GRB.INTEGER)
    x3 = model.addVar(name="mechanical pencils", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(5.78*x0 + 4.79*x1 + 1.44*x2 + 8.87*x3, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(3*x0 + 26*x1 + 11*x2 + 6*x3 <= 373, name="storage_space")
    model.addConstr(22*x0 + 21*x1 + 28*x2 + 9*x3 <= 294, name="sustainability_score")
    model.addConstr(26*x1 + 11*x2 >= 75, name="storage_smoke_hole")
    model.addConstr(26*x1 + 6*x3 >= 77, name="storage_smoke_pencil")
    model.addConstr(3*x0 + 26*x1 + 6*x3 >= 93, name="storage_scissors_smoke_pencil")
    model.addConstr(21*x1 + 28*x2 <= 105, name="sustainability_smoke_hole")
    model.addConstr(28*x2 + 9*x3 <= 122, name="sustainability_hole_pencil")
    model.addConstr(22*x0 + 9*x3 <= 144, name="sustainability_scissors_pencil")
    model.addConstr(22*x0 + 28*x2 <= 140, name="sustainability_scissors_hole")
    model.addConstr(22*x0 + 28*x2 + 9*x3 <= 93, name="sustainability_scissors_hole_pencil")
    model.addConstr(22*x0 + 21*x1 + 28*x2 + 9*x3 <= 93, name="sustainability_all")
    model.addConstr(3*x0 + 26*x1 <= 327, name="storage_scissors_smoke")
    model.addConstr(3*x0 + 6*x3 <= 157, name="storage_scissors_pencil")
    model.addConstr(3*x0 + 11*x2 <= 251, name="storage_scissors_hole")
    model.addConstr(11*x2 + 6*x3 <= 175, name="storage_hole_pencil")
    model.addConstr(3*x0 + 26*x1 + 6*x3 <= 184, name="storage_scissors_smoke_pencil")
    model.addConstr(3*x0 + 26*x1 + 11*x2 + 6*x3 <= 184, name="storage_all")

    # Integrate all the constraints
    model.update()

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Scissors: ", x0.varValue)
        print("Smoke Detectors: ", x1.varValue)
        print("Hole Punches: ", x2.varValue)
        print("Mechanical Pencils: ", x3.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
