
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x0 = m.addVar(name="zinc", lb=0, vtype=gp.GRB.CONTINUOUS)
x1 = m.addVar(name="vitamin_B6", lb=0, vtype=gp.GRB.CONTINUOUS)
x2 = m.addVar(name="vitamin_C", lb=0, vtype=gp.GRB.CONTINUOUS)
x3 = m.addVar(name="calcium", lb=0, vtype=gp.GRB.CONTINUOUS)
x4 = m.addVar(name="carbohydrates", lb=0, vtype=gp.GRB.CONTINUOUS)
x5 = m.addVar(name="protein", lb=0, vtype=gp.GRB.CONTINUOUS)
x6 = m.addVar(name="iron", lb=0, vtype=gp.GRB.CONTINUOUS)

# Objective function
m.setObjective(9.89*x0 + 1.51*x1 + 2.87*x2 + 4.27*x3 + 6.7*x4 + 7.82*x5 + 8.78*x6, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(5*x0 + 6*x1 + 3*x2 + 6*x3 + 6*x4 + 5*x5 + 5*x6 <= 206)
m.addConstr(7*x0 + 6*x1 + 4*x2 + 3*x3 + 3*x4 + 2*x5 + 4*x6 <= 89)
m.addConstr(1*x0 + 1*x1 + 8*x2 + 4*x3 + 1*x4 + 4*x5 + 3*x6 <= 223)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Zinc: ", x0.varValue)
    print("Vitamin B6: ", x1.varValue)
    print("Vitamin C: ", x2.varValue)
    print("Calcium: ", x3.varValue)
    print("Carbohydrates: ", x4.varValue)
    print("Protein: ", x5.varValue)
    print("Iron: ", x6.varValue)
else:
    print("No optimal solution found")
