
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    dale = m.addVar(vtype=gp.GRB.CONTINUOUS, name="dale")
    laura = m.addVar(vtype=gp.GRB.CONTINUOUS, name="laura")
    john = m.addVar(vtype=gp.GRB.CONTINUOUS, name="john")
    peggy = m.addVar(vtype=gp.GRB.CONTINUOUS, name="peggy")
    hank = m.addVar(vtype=gp.GRB.CONTINUOUS, name="hank")


    # Set objective function
    m.setObjective(1.88 * dale + 7.5 * laura + 9.6 * john + 3.92 * peggy + 6.52 * hank, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(18 * laura + 17 * peggy >= 116)
    m.addConstr(13 * dale + 9 * john >= 105)
    m.addConstr(13 * dale + 11 * hank >= 88)
    m.addConstr(18 * laura + 11 * hank >= 80)
    m.addConstr(9 * john + 17 * peggy >= 96)
    m.addConstr(13 * dale + 18 * laura + 9 * john >= 92)
    m.addConstr(9 * john + 17 * peggy + 11 * hank >= 92)
    m.addConstr(13 * dale + 18 * laura + 9 * john >= 84)
    m.addConstr(9 * john + 17 * peggy + 11 * hank >= 84)
    m.addConstr(18 * laura + 11 * hank <= 294)
    m.addConstr(17 * peggy + 11 * hank <= 265)
    m.addConstr(18 * laura + 17 * peggy <= 451)
    m.addConstr(13 * dale + 9 * john <= 176)
    m.addConstr(13 * dale + 18 * laura <= 481)
    m.addConstr(13 * dale + 11 * hank <= 300)
    m.addConstr(9 * john + 11 * hank <= 575)
    m.addConstr(13 * dale + 18 * laura + 9 * john + 17 * peggy + 11 * hank <= 575)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("Optimization ended with status:", m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
