
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="hours_worked_by_Dale", lb=0)
    x2 = model.addVar(name="hours_worked_by_Laura", lb=0)
    x3 = model.addVar(name="hours_worked_by_John", lb=0)
    x4 = model.addVar(name="hours_worked_by_Peggy", lb=0)
    x5 = model.addVar(name="hours_worked_by_Hank", lb=0)

    # Define the objective function
    model.setObjective(1.88 * x1 + 7.5 * x2 + 9.6 * x3 + 3.92 * x4 + 6.52 * x5, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(13 * x1 + 18 * x2 + 9 * x3 + 17 * x4 + 11 * x5 <= 596)
    model.addConstr(18 * x2 + 17 * x4 >= 116)
    model.addConstr(13 * x1 + 9 * x3 >= 105)
    model.addConstr(13 * x1 + 11 * x5 >= 88)
    model.addConstr(18 * x2 + 11 * x5 >= 80)
    model.addConstr(9 * x3 + 17 * x4 >= 96)
    model.addConstr(13 * x1 + 18 * x2 + 9 * x3 >= 92)
    model.addConstr(9 * x3 + 17 * x4 + 11 * x5 >= 92)
    model.addConstr(13 * x1 + 18 * x2 + 9 * x3 >= 84)
    model.addConstr(9 * x3 + 17 * x4 + 11 * x5 >= 84)
    model.addConstr(18 * x2 + 11 * x5 <= 294)
    model.addConstr(17 * x4 + 11 * x5 <= 265)
    model.addConstr(18 * x2 + 17 * x4 <= 451)
    model.addConstr(13 * x1 + 9 * x3 <= 176)
    model.addConstr(13 * x1 + 18 * x2 <= 481)
    model.addConstr(13 * x1 + 11 * x5 <= 300)
    model.addConstr(9 * x3 + 11 * x5 <= 575)
    model.addConstr(13 * x1 + 18 * x2 + 9 * x3 + 17 * x4 + 11 * x5 <= 575)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Hours worked by Dale: ", x1.varValue)
        print("Hours worked by Laura: ", x2.varValue)
        print("Hours worked by John: ", x3.varValue)
        print("Hours worked by Peggy: ", x4.varValue)
        print("Hours worked by Hank: ", x5.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
