
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0")
x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x1")
x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x2")
x3 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x3")


# Set objective function
m.setObjective(8*x0 + 5*x1 + 1*x2 + 9*x3, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(1.74*x0 + 1.62*x1 + 1.3*x2 + 0.06*x3 <= 92)
m.addConstr(1.51*x0 + 1.51*x1 + 1.99*x2 + 0.64*x3 <= 146)
m.addConstr(1.9*x0 + 0.67*x1 + 1.31*x2 + 0.15*x3 <= 117)
m.addConstr(0.06*x0 + 0.96*x1 + 1.58*x2 + 1.97*x3 <= 111)
m.addConstr(1.74*x0 + 1.3*x2 >= 20)
m.addConstr(1.51*x0 + 1.51*x1 >= 16)
m.addConstr(1.51*x1 + 0.64*x3 >= 30)
m.addConstr(1.51*x0 + 1.99*x2 >= 33)
m.addConstr(1.51*x1 + 1.99*x2 >= 24)
m.addConstr(1.51*x0 + 0.64*x3 >= 14)
m.addConstr(1.51*x0 + 1.51*x1 + 1.99*x2 >= 26)
m.addConstr(1.51*x1 + 1.99*x2 + 0.64*x3 >= 26)
m.addConstr(1.9*x0 + 1.31*x2 >= 11)
m.addConstr(1.31*x2 + 0.15*x3 >= 15)
m.addConstr(0.67*x1 + 1.31*x2 + 0.15*x3 >= 14)
m.addConstr(1.9*x0 + 1.31*x2 + 0.15*x3 >= 14)
m.addConstr(1.9*x0 + 0.67*x1 + 1.31*x2 >= 14)
m.addConstr(0.06*x0 + 1.97*x3 >= 27)
m.addConstr(1.58*x2 + 1.97*x3 >= 14)
m.addConstr(0.96*x1 + 1.58*x2 >= 13)
m.addConstr(0.06*x0 + 0.96*x1 >= 12)
m.addConstr(9*x0 - 10*x3 >= 0)
m.addConstr(1.62*x1 + 1.3*x2 <= 45)
m.addConstr(1.3*x2 + 0.06*x3 <= 53)
m.addConstr(1.62*x1 + 0.06*x3 <= 80)
m.addConstr(1.74*x0 + 1.62*x1 + 1.3*x2 + 0.06*x3 <= 80)
m.addConstr(1.51*x1 + 0.64*x3 <= 43)
m.addConstr(1.51*x0 + 1.51*x1 + 1.99*x2 <= 122)
m.addConstr(1.51*x0 + 1.51*x1 + 0.64*x3 <= 119)
m.addConstr(1.51*x0 + 1.99*x2 + 0.64*x3 <= 67)
m.addConstr(1.51*x1 + 1.99*x2 + 0.64*x3 <= 146)
m.addConstr(1.51*x0 + 1.51*x1 + 1.99*x2 + 0.64*x3 <= 146)
m.addConstr(0.67*x1 + 0.15*x3 <= 107)
m.addConstr(1.31*x2 + 0.15*x3 <= 101)
m.addConstr(1.9*x0 + 0.15*x3 <= 104)
m.addConstr(0.67*x1 + 1.31*x2 <= 64)
m.addConstr(0.67*x1 + 1.31*x2 + 0.15*x3 <= 105)
m.addConstr(1.9*x0 + 0.67*x1 + 0.15*x3 <= 85)
m.addConstr(1.9*x0 + 0.67*x1 + 1.31*x2 <= 78)
m.addConstr(1.9*x0 + 0.67*x1 + 1.31*x2 + 0.15*x3 <= 78)
m.addConstr(1.58*x2 + 1.97*x3 <= 37)
m.addConstr(0.96*x1 + 1.97*x3 <= 64)
m.addConstr(0.06*x0 + 1.58*x2 <= 70)
m.addConstr(0.96*x1 + 1.58*x2 <= 71)
m.addConstr(0.06*x0 + 0.96*x1 + 1.58*x2 + 1.97*x3 <= 71)



# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

