
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=-gurobi.GRB.INFINITY, name='milligrams of vitamin E', vtype=gurobi.GRB.CONTINUOUS)
    x2 = model.addVar(lb=-gurobi.GRB.INFINITY, name='grams of fat', vtype=gurobi.GRB.CONTINUOUS)
    x3 = model.addVar(lb=-gurobi.GRB.INFINITY, name='grams of protein', vtype=gurobi.GRB.CONTINUOUS)
    x4 = model.addVar(lb=-gurobi.GRB.INFINITY, name='milligrams of vitamin B4', vtype=gurobi.GRB.CONTINUOUS)

    # Define the objective function
    model.setObjective(3.58*x1 + 5.69*x2 + 3.28*x3 + 2.48*x4, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(11*x1 <= 171)
    model.addConstr(14*x2 <= 171)
    model.addConstr(11*x3 <= 171)
    model.addConstr(13*x4 <= 171)
    model.addConstr(11*x1 + 14*x2 + 13*x4 >= 40)
    model.addConstr(11*x1 + 11*x3 + 13*x4 >= 40)
    model.addConstr(11*x1 + 14*x2 + 13*x4 >= 36)
    model.addConstr(11*x1 + 11*x3 + 13*x4 >= 36)
    model.addConstr(11*x1 + 11*x3 <= 124)
    model.addConstr(11*x3 + 13*x4 <= 146)
    model.addConstr(11*x1 + 14*x2 <= 152)
    model.addConstr(14*x2 + 13*x4 <= 81)
    model.addConstr(11*x1 + 14*x2 + 11*x3 + 13*x4 <= 81)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Objective: ', model.objVal)
        print('x1: ', x1.varValue)
        print('x2: ', x2.varValue)
        print('x3: ', x3.varValue)
        print('x4: ', x4.varValue)
    else:
        print('The model is infeasible')

solve_optimization_problem()
