
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("vitamin_optimization")

    # Create variables
    vitamin_b3 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b3")
    vitamin_b9 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b9")
    vitamin_b5 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b5")
    vitamin_b7 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b7")


    # Set objective function
    m.setObjective(7*vitamin_b3 + 6*vitamin_b9 + 9*vitamin_b5 + 8*vitamin_b7, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(1*vitamin_b3 + 14*vitamin_b7 >= 32)
    m.addConstr(11*vitamin_b9 + 14*vitamin_b7 >= 17)
    m.addConstr(10*vitamin_b5 + 14*vitamin_b7 >= 40)
    m.addConstr(1*vitamin_b3 + 11*vitamin_b9 >= 44)
    m.addConstr(11*vitamin_b9 + 10*vitamin_b5 >= 19)
    m.addConstr(1*vitamin_b3 + 11*vitamin_b9 + 10*vitamin_b5 + 14*vitamin_b7 >= 19)
    m.addConstr(16*vitamin_b9 + 12*vitamin_b7 >= 26)
    m.addConstr(11*vitamin_b3 + 12*vitamin_b5 >= 43)
    m.addConstr(16*vitamin_b9 + 12*vitamin_b5 >= 51)
    m.addConstr(11*vitamin_b3 + 12*vitamin_b7 >= 52)
    m.addConstr(11*vitamin_b3 + 16*vitamin_b9 + 12*vitamin_b5 >= 35)
    m.addConstr(11*vitamin_b3 + 16*vitamin_b9 + 12*vitamin_b5 + 12*vitamin_b7 >= 35)
    m.addConstr(-1*vitamin_b3 + 8*vitamin_b9 >= 0)
    m.addConstr(-5*vitamin_b5 + 1*vitamin_b7 >= 0)
    m.addConstr(-8*vitamin_b9 + 6*vitamin_b7 >= 0)
    m.addConstr(11*vitamin_b9 + 14*vitamin_b7 <= 147)
    m.addConstr(1*vitamin_b3 + 11*vitamin_b9 <= 191)
    m.addConstr(1*vitamin_b3 + 14*vitamin_b7 <= 102)
    m.addConstr(10*vitamin_b5 + 14*vitamin_b7 <= 160)
    m.addConstr(1*vitamin_b3 + 10*vitamin_b5 <= 92)
    m.addConstr(1*vitamin_b3 + 10*vitamin_b5 + 14*vitamin_b7 <= 185)
    m.addConstr(11*vitamin_b3 + 16*vitamin_b9 <= 230)
    m.addConstr(16*vitamin_b9 + 12*vitamin_b5 <= 144)
    m.addConstr(16*vitamin_b9 + 12*vitamin_b7 <= 227)
    m.addConstr(11*vitamin_b3 + 12*vitamin_b7 <= 151)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Model is infeasible')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ": " + str(e))

except AttributeError:
    print('Encountered an attribute error')
