
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.INTEGER, name="automatic_alerts")
    x1 = m.addVar(vtype=gp.GRB.INTEGER, name="Mbps_bandwidth")
    x2 = m.addVar(vtype=gp.GRB.INTEGER, name="SOC_operators")


    # Set objective function
    m.setObjective(3.42 * x0 + 4.6 * x1 + 9.52 * x2, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(8 * x0 + 3 * x1 + 6 * x2 <= 108, "network_latency_impact")
    m.addConstr(7 * x0 + 3 * x1 + 4 * x2 <= 75, "available_bandwidth_impact")
    m.addConstr(8 * x0 + 6 * x2 >= 21, "min_latency_alerts_operators")
    m.addConstr(8 * x0 + 3 * x1 >= 23, "min_latency_alerts_bandwidth")
    m.addConstr(8 * x0 + 3 * x1 + 6 * x2 >= 32, "min_total_latency")
    m.addConstr(7 * x0 + 3 * x1 >= 13, "min_bandwidth_alerts_bandwidth")
    m.addConstr(3 * x1 + 4 * x2 >= 17, "min_bandwidth_bandwidth_operators")
    m.addConstr(7 * x0 + 3 * x1 + 4 * x2 >= 17, "min_total_bandwidth")
    m.addConstr(3 * x1 - 7 * x2 >= 0, "constraint_bandwidth_operators")
    m.addConstr(5 * x0 - 8 * x2 >= 0, "constraint_alerts_operators")
    m.addConstr(8 * x0 + 6 * x2 <= 79, "max_latency_alerts_operators")
    m.addConstr(3 * x1 + 6 * x2 <= 55, "max_latency_bandwidth_operators")
    m.addConstr(7 * x0 + 3 * x1 <= 65, "max_bandwidth_alerts_bandwidth")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
