
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name='automatic_alerts', vtype=gurobi.GRB.INTEGER)  # automatic alerts
    x1 = model.addVar(name='mbps_bandwidth', vtype=gurobi.GRB.INTEGER)  # Mbps bandwidth allocated to monitoring
    x2 = model.addVar(name='soc_operators', vtype=gurobi.GRB.INTEGER)  # SOC operators

    # Define the objective function
    model.setObjective(3.42 * x0 + 4.6 * x1 + 9.52 * x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(8 * x0 + 3 * x1 + 6 * x2 <= 108)  # network latency impact
    model.addConstr(7 * x0 + 3 * x1 + 4 * x2 <= 75)  # available bandwidth impact
    model.addConstr(8 * x0 + 6 * x2 >= 21)  # network latency from automatic alerts and SOC operators
    model.addConstr(8 * x0 + 3 * x1 >= 23)  # combined network latency from automatic alerts and Mbps bandwidth allocated to monitoring
    model.addConstr(8 * x0 + 3 * x1 + 6 * x2 >= 32)  # combined network latency from all
    model.addConstr(7 * x0 + 3 * x1 >= 13)  # bandwidth used by automatic alerts and Mbps bandwidth allocated to monitoring
    model.addConstr(3 * x1 + 4 * x2 >= 17)  # bandwidth used by Mbps bandwidth allocated to monitoring and SOC operators
    model.addConstr(7 * x0 + 3 * x1 + 4 * x2 >= 17)  # minimum bandwidth used by all
    model.addConstr(3 * x1 - 7 * x2 >= 0)  # relationship between Mbps bandwidth allocated to monitoring and SOC operators
    model.addConstr(5 * x0 - 8 * x2 >= 0)  # relationship between automatic alerts and SOC operators
    model.addConstr(8 * x0 + 6 * x2 <= 79)  # network latency from automatic alerts and SOC operators
    model.addConstr(3 * x1 + 6 * x2 <= 55)  # combined network latency from Mbps bandwidth allocated to monitoring and SOC operators
    model.addConstr(7 * x0 + 3 * x1 <= 65)  # available bandwidth from automatic alerts and Mbps bandwidth allocated to monitoring

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Automatic alerts: {x0.varValue}")
        print(f"Mbps bandwidth allocated to monitoring: {x1.varValue}")
        print(f"SOC operators: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
