
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimize_work_hours")

    # Create variables
    ringo_hours = model.addVar(vtype=gp.GRB.INTEGER, name="x0")  # Ringo's hours, integer
    john_hours = model.addVar(vtype=gp.GRB.CONTINUOUS, name="x1") # John's hours, continuous

    # Set objective function
    model.setObjective(9 * ringo_hours + 2 * john_hours, gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(6 * ringo_hours + 12 * john_hours >= 52, "c1")
    model.addConstr(7 * ringo_hours + 11 * john_hours >= 52, "c2")
    model.addConstr(5 * ringo_hours + 11 * john_hours >= 21, "c3")
    model.addConstr(9 * ringo_hours + 14 * john_hours >= 21, "c4")
    model.addConstr(-8 * ringo_hours + 5 * john_hours >= 0, "c5")
    model.addConstr(6 * ringo_hours + 12 * john_hours <= 94, "c6")
    model.addConstr(7 * ringo_hours + 11 * john_hours <= 70, "c7")
    model.addConstr(5 * ringo_hours + 11 * john_hours <= 61, "c8")
    model.addConstr(9 * ringo_hours + 14 * john_hours <= 37, "c9")


    # Optimize model
    model.optimize()

    # Check for infeasibility
    if model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    # Print solution if feasible
    elif model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        print('Ringo Hours: %g' % ringo_hours.x)
        print('John Hours: %g' % john_hours.x)
    else:
        print(f"Optimization terminated with status {model.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
