
import gurobi as gp

# Create a new model
m = gp.Model()

# Define the variables
x1 = m.addVar(name="hours_worked_by_Ringo", vtype=gp.GRB.INTEGER)  # integer
x2 = m.addVar(name="hours_worked_by_John")  # continuous

# Define the objective function
m.setObjective(9 * x1 + 2 * x2, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(6 * x1 + 12 * x2 >= 52)
m.addConstr(7 * x1 + 11 * x2 >= 52)
m.addConstr(5 * x1 + 11 * x2 >= 21)
m.addConstr(9 * x1 + 14 * x2 >= 21)
m.addConstr(-8 * x1 + 5 * x2 >= 0)
m.addConstr(6 * x1 + 12 * x2 <= 94)
m.addConstr(7 * x1 + 11 * x2 <= 70)
m.addConstr(5 * x1 + 11 * x2 <= 61)
m.addConstr(9 * x1 + 14 * x2 <= 37)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by Ringo: {x1.varValue}")
    print(f"Hours worked by John: {x2.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
