
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    ravioli = m.addVar(vtype=gp.GRB.INTEGER, name="ravioli")
    rotisserie_chickens = m.addVar(vtype=gp.GRB.CONTINUOUS, name="rotisserie_chickens")

    # Set objective function
    m.setObjective(5.73 * ravioli**2 + 1.63 * rotisserie_chickens, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(4 * ravioli + 18 * rotisserie_chickens <= 173, "c0")
    m.addConstr(19 * ravioli + 4 * rotisserie_chickens <= 225, "c1")
    m.addConstr(7 * ravioli + 25 * rotisserie_chickens <= 122, "c2")
    m.addConstr(16 * ravioli + 23 * rotisserie_chickens <= 245, "c3")
    m.addConstr(15 * ravioli + 7 * rotisserie_chickens <= 207, "c4")
    m.addConstr(ravioli**2 + rotisserie_chickens**2 >= 57, "c5")
    m.addConstr(19 * ravioli + 4 * rotisserie_chickens >= 67, "c6")
    m.addConstr(7 * ravioli + 25 * rotisserie_chickens >= 47, "c7")
    m.addConstr(16 * ravioli**2 + 23 * rotisserie_chickens**2 >= 108, "c8")
    m.addConstr(15 * ravioli + 7 * rotisserie_chickens >= 65, "c9")
    m.addConstr(-9 * ravioli + 2 * rotisserie_chickens >= 0, "c10")
    m.addConstr(4 * ravioli + 18 * rotisserie_chickens <= 100, "c11")
    m.addConstr(19 * ravioli + 4 * rotisserie_chickens <= 158, "c12")
    m.addConstr(7 * ravioli + 25 * rotisserie_chickens <= 119, "c13")
    m.addConstr(16 * ravioli + 23 * rotisserie_chickens <= 197, "c14")
    m.addConstr(15 * ravioli + 7 * rotisserie_chickens <= 149, "c15")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('ravioli:', ravioli.x)
        print('rotisserie_chickens:', rotisserie_chickens.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
