
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()
    
    # Define variables
    x1 = model.addVar(name="ravioli", vtype=gurobi.GRB.INTEGER, lb=0)
    x2 = model.addVar(name="rotisserie_chickens", vtype=gurobi.GRB.CONTINUOUS, lb=0)
    
    # Objective function
    model.setObjective(5.73 * x1**2 + 1.63 * x2, gurobi.GRB.MAXIMIZE)
    
    # Constraints
    model.addConstr(4 * x1 + 18 * x2 <= 100, name="healthiness_rating")
    model.addConstr(19 * x1 + 4 * x2 >= 67, name="protein_min")
    model.addConstr(19 * x1 + 4 * x2 <= 158, name="protein_max")
    model.addConstr(7 * x1 + 25 * x2 >= 47, name="sourness_index_min")
    model.addConstr(7 * x1 + 25 * x2 <= 119, name="sourness_index_max")
    model.addConstr(16 * x1**2 + 23 * x2**2 >= 108, name="fiber_min")
    model.addConstr(16 * x1 + 23 * x2 <= 197, name="fiber_max")
    model.addConstr(15 * x1 + 7 * x2 >= 65, name="iron_min")
    model.addConstr(15 * x1 + 7 * x2 <= 149, name="iron_max")
    model.addConstr(x1**2 + x2**2 >= 57, name="combined_rating_min")
    model.addConstr(-9 * x1 + 2 * x2 >= 0, name="ratio_constraint")
    
    # Solve the model
    model.optimize()
    
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Ravioli: {x1.varValue}")
        print(f"Rotisserie Chickens: {x2.varValue}")
        print(f"Objective: {model.objVal}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("The model has a non-optimal status.")

solve_optimization_problem()
