
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x0")
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x1")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x2")
x3 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x3")
x4 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x4")


# Set objective function
m.setObjective(x0**2 + 4*x0*x1 + 2*x0*x3 + 8*x0*x4 + 4*x1*x2 + 9*x1*x3 + 7*x1*x4 + 3*x2**2 + 7*x2*x3 + 3*x2*x4 + 3*x3**2 + 5*x3*x4 + 2*x4**2 + 2*x1 + 9*x2 + 3*x3 + 2*x4, GRB.MAXIMIZE)

# Add constraints
m.addConstr(4*x0 + 5*x4 >= 33)
m.addConstr(4*x1**2 + 3*x2**2 >= 32)
m.addConstr(4*x0 + 3*x2 >= 21)
m.addConstr(4*x1 + 2*x3 >= 28)
m.addConstr(4*x1 + 3*x2 + 2*x3 >= 16)
m.addConstr(4*x1 + 3*x2 + 5*x4 >= 16)
m.addConstr(3*x2 + 2*x3 + 5*x4 >= 16)
m.addConstr(4*x1 + 3*x2 + 2*x3 >= 28)
m.addConstr(4*x1 + 3*x2 + 5*x4 >= 28)
m.addConstr(3*x2**2 + 2*x3**2 + 5*x4**2 >= 28)
m.addConstr(4*x1 + 3*x2 + 2*x3 >= 32)
m.addConstr(4*x1 + 3*x2 + 5*x4 >= 32)
m.addConstr(3*x2 + 2*x3 + 5*x4 >= 32)
m.addConstr(2*x1 + 4*x2 + 7*x3 >= 16)
m.addConstr(3*x0 + 2*x1 + 4*x2 >= 16)
m.addConstr(2*x1 + 4*x2 + 7*x3 >= 24)
m.addConstr(3*x0 + 2*x1 + 4*x2 >= 24)
m.addConstr(2*x3**2 + 5*x4**2 <= 62)
m.addConstr(4*x1**2 + 3*x2**2 <= 112)
m.addConstr(4*x0**2 + 4*x1**2 + 5*x4**2 <= 134)
m.addConstr(4*x0**2 + 3*x2**2 + 2*x3**2 <= 46)
m.addConstr(4*x0 + 2*x3 + 5*x4 <= 111)
m.addConstr(3*x2 + 2*x3 + 5*x4 <= 83)
m.addConstr(4*x1**2 + 3*x2**2 + 2*x3**2 <= 72)
m.addConstr(4*x0 + 4*x1 + 3*x2 + 2*x3 + 5*x4 <= 72)
m.addConstr(3*x0 + 4*x2 <= 138)
m.addConstr(7*x3 + x4 <= 156)
m.addConstr(3*x0 + 2*x1 <= 37)
m.addConstr(2*x1 + x4 <= 38)
m.addConstr(3*x0 + 7*x3 <= 120)
m.addConstr(3*x0**2 + x4**2 <= 104)
m.addConstr(4*x2 + 7*x3 <= 53)
m.addConstr(4*x2 + x4 <= 33)
m.addConstr(3*x0 + 7*x3 + x4 <= 73)
m.addConstr(3*x0 + 2*x1 + 7*x3 <= 103)
m.addConstr(3*x0 + 2*x1 + x4 <= 42)
m.addConstr(4*x2**2 + 7*x3**2 + x4**2 <= 78)
m.addConstr(2*x1 + 4*x2 + x4 <= 76)
m.addConstr(3*x0**2 + 4*x2**2 + 7*x3**2 <= 56)
m.addConstr(3*x0 + 2*x1 + 4*x2 <= 111)
m.addConstr(2*x1 + 4*x2 + 7*x3 <= 140)
m.addConstr(2*x1**2 + 7*x3**2 + x4**2 <= 85)
m.addConstr(3*x0 + 2*x1 + 4*x2 + 7*x3 + x4 <= 85)


# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print('Optimization problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

