
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x = m.addVars(6, vtype=gp.GRB.INTEGER, name=["potato vines", "apple trees", "squash plants", "cherry trees", "carrots", "coleus"])


# Set objective function
m.setObjective(1.4 * x[0] + 7.22 * x[1] + 1.36 * x[2] + 2.36 * x[3] + 7.91 * x[4] + 2.85 * x[5], gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(10 * x[0] + 5 * x[1] + 6 * x[2] + 12 * x[3] + 13 * x[4] + 1 * x[5] <= 153, "r0")
m.addConstr(1 * x[0] + 1 * x[1] + 12 * x[2] + 7 * x[3] + 7 * x[4] + 14 * x[5] <= 144, "r1")
m.addConstr(5 * x[1] + 6 * x[2] + 1 * x[5] >= 16, "c1")
m.addConstr(12 * x[2] + 7 * x[4] >= 14, "c2")
m.addConstr(7 * x[3] + 14 * x[5] >= 15, "c3")
m.addConstr(1 * x[1] + 12 * x[2] >= 23, "c4")
m.addConstr(1 * x[1] + 12 * x[2] + 14 * x[5] >= 19, "c5")
# ... (add all other constraints similarly)
m.addConstr(5 * x[1] + 13 * x[4] <= 128, "c_last-1")
m.addConstr(x[0] + x[1] + 12 * x[2] + 7 * x[3] + 7 * x[4] + 14 * x[5] <= 40, "c_last")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

