
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    model = gp.Model("optimize_work_hours")

    # Create variables
    paul_hours = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="paul_hours")
    ringo_hours = model.addVar(lb=0, vtype=GRB.INTEGER, name="ringo_hours")

    # Set objective function
    model.setObjective(1.67 * paul_hours * ringo_hours + 6.79 * ringo_hours, GRB.MINIMIZE)

    # Add constraints
    model.addConstr(19 * paul_hours**2 + 2 * ringo_hours**2 >= 44, "c0")
    model.addConstr(19 * paul_hours + 2 * ringo_hours >= 44, "c1")
    model.addConstr(18 * paul_hours + 7 * ringo_hours >= 31, "c2")
    model.addConstr(14 * paul_hours + 14 * ringo_hours >= 56, "c3")
    model.addConstr(13 * paul_hours + 18 * ringo_hours >= 46, "c4")
    model.addConstr(6 * paul_hours - 10 * ringo_hours >= 0, "c5")
    model.addConstr(19 * paul_hours + 2 * ringo_hours <= 94, "c6")
    model.addConstr(18 * paul_hours + 7 * ringo_hours <= 82, "c7")
    model.addConstr(14 * paul_hours**2 + 14 * ringo_hours**2 <= 119, "c8")
    model.addConstr(13 * paul_hours + 18 * ringo_hours <= 93, "c9")


    # Optimize model
    model.optimize()

    if model.status == GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        print('Paul Hours: %g' % paul_hours.x)
        print('Ringo Hours: %g' % ringo_hours.x)
    elif model.status == GRB.INFEASIBLE:
        print('Model is infeasible')
    else:
        print('Optimization ended with status %d' % model.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
