
import gurobi as gp

m = gp.Model()

x1 = m.addVar(name="hours_worked_by_Paul", lb=0)
x2 = m.addVar(name="hours_worked_by_Ringo", lb=0, integrality=gp.GRB.Integer)

m.setObjective(1.67 * x1 * x2 + 6.79 * x2, gp.GRB.MINIMIZE)

m.addConstr(19 * x1 + 2 * x2 >= 44, name="paperwork_1")
m.addConstr(18 * x1 + 7 * x2 >= 31, name="dollar_cost")
m.addConstr(14 * x1 + 14 * x2 >= 56, name="organization_score")
m.addConstr(13 * x1 + 18 * x2 >= 46, name="computer_competence")
m.addConstr(6 * x1 - 10 * x2 >= 0, name="six_x1_minus_ten_x2")
m.addConstr(18 * x1 + 7 * x2 <= 82, name="dollar_cost_upper")
qc1 = m.addQConstr(14 * x1**2 + 14 * x2**2 <= 158, name="organization_score_upper")
m.addConstr(13 * x1 + 18 * x2 <= 93, name="computer_competence_upper")
qc2 = m.addQConstr(19 * x1**2 + 2 * x2**2 <= 148, name="paperwork_upper")

m.optimize()

if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by Paul: {x1.varValue}")
    print(f"Hours worked by Ringo: {x2.varValue}")
else:
    print("No optimal solution found.")
