
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
apple_pies = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="apple_pies")
apples = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="apples")
oreos = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="oreos")
bowls_of_cereal = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bowls_of_cereal")


# Set objective function
m.setObjective(8*apple_pies + 4*apples + 7*oreos + 3*bowls_of_cereal, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(18*apples + 18*oreos >= 15)
m.addConstr(6*apple_pies + 18*apples >= 36)
m.addConstr(6*apple_pies + 21*bowls_of_cereal >= 29)
m.addConstr(6*apple_pies + 18*oreos >= 18)
m.addConstr(6*apple_pies + 18*apples + 18*oreos >= 27)
m.addConstr(6*apple_pies + 18*oreos + 21*bowls_of_cereal >= 27)
m.addConstr(18*apples + 18*oreos + 21*bowls_of_cereal >= 27)
m.addConstr(6*apple_pies + 18*apples + 18*oreos >= 41)
m.addConstr(6*apple_pies + 18*oreos + 21*bowls_of_cereal >= 41)
m.addConstr(18*apples + 18*oreos + 21*bowls_of_cereal >= 41)
m.addConstr(6*apple_pies + 18*apples + 18*oreos >= 23)
m.addConstr(6*apple_pies + 18*oreos + 21*bowls_of_cereal >= 23)
m.addConstr(18*apples + 18*oreos + 21*bowls_of_cereal >= 23)
m.addConstr(6*apple_pies + 18*apples + 18*oreos + 21*bowls_of_cereal >= 23)
m.addConstr(12*apple_pies + 15*apples >= 18)
m.addConstr(15*apples + 11*oreos >= 17)
m.addConstr(12*apple_pies + 11*oreos >= 36)
m.addConstr(11*oreos + 4*bowls_of_cereal >= 20)
m.addConstr(12*apple_pies + 15*apples + 4*bowls_of_cereal >= 37)
m.addConstr(12*apple_pies + 15*apples + 11*oreos >= 37)
m.addConstr(12*apple_pies + 15*apples + 4*bowls_of_cereal >= 24)
m.addConstr(12*apple_pies + 15*apples + 11*oreos >= 24)
m.addConstr(12*apple_pies + 15*apples + 11*oreos + 4*bowls_of_cereal >= 24)
m.addConstr(-9*oreos + 1*bowls_of_cereal >= 0)
m.addConstr(6*apple_pies + 18*apples + 18*oreos <= 72)
m.addConstr(6*apple_pies + 18*apples + 21*bowls_of_cereal <= 74)
m.addConstr(18*apples + 18*oreos + 21*bowls_of_cereal <= 50)
m.addConstr(6*apple_pies + 18*oreos + 21*bowls_of_cereal <= 158)
m.addConstr(12*apple_pies + 15*apples <= 102)
m.addConstr(15*apples + 11*oreos <= 155)
m.addConstr(12*apple_pies + 11*oreos + 4*bowls_of_cereal <= 116)


# Resource Constraints
m.addConstr(6*apple_pies + 18*apples + 18*oreos + 21*bowls_of_cereal <= 175) # fat
m.addConstr(12*apple_pies + 15*apples + 11*oreos + 4*bowls_of_cereal <= 157) # fiber


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The problem is infeasible.")
else:
    print("The problem could not be solved to optimality.")

