
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="apple_pies", lb=0)
    x1 = model.addVar(name="apples", lb=0)
    x2 = model.addVar(name="oreos", lb=0)
    x3 = model.addVar(name="bowls_of_cereal", lb=0)

    # Objective function
    model.setObjective(8*x0 + 4*x1 + 7*x2 + 3*x3, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(6*x0 + 18*x1 + 18*x2 + 21*x3 <= 175)
    model.addConstr(12*x0 + 15*x1 + 11*x2 + 4*x3 <= 157)
    model.addConstr(18*x1 + 18*x2 >= 15)
    model.addConstr(6*x0 + 18*x1 >= 36)
    model.addConstr(6*x0 + 21*x3 >= 29)
    model.addConstr(6*x0 + 18*x2 >= 18)
    model.addConstr(6*x0 + 18*x1 + 18*x2 >= 27)
    model.addConstr(6*x0 + 18*x2 + 21*x3 >= 27)
    model.addConstr(18*x1 + 18*x2 + 21*x3 >= 27)
    model.addConstr(6*x0 + 18*x1 + 18*x2 >= 41)
    model.addConstr(6*x0 + 18*x2 + 21*x3 >= 41)
    model.addConstr(18*x1 + 18*x2 + 21*x3 >= 41)
    model.addConstr(6*x0 + 18*x1 + 18*x2 >= 23)
    model.addConstr(6*x0 + 18*x2 + 21*x3 >= 23)
    model.addConstr(18*x1 + 18*x2 + 21*x3 >= 23)
    model.addConstr(6*x0 + 18*x1 + 18*x2 + 21*x3 >= 23)
    model.addConstr(12*x0 + 15*x1 >= 18)
    model.addConstr(15*x1 + 11*x2 >= 17)
    model.addConstr(12*x0 + 11*x2 >= 36)
    model.addConstr(11*x2 + 4*x3 >= 20)
    model.addConstr(12*x0 + 15*x1 + 4*x3 >= 37)
    model.addConstr(12*x0 + 15*x1 + 11*x2 >= 37)
    model.addConstr(12*x0 + 15*x1 + 4*x3 >= 24)
    model.addConstr(12*x0 + 15*x1 + 11*x2 >= 24)
    model.addConstr(12*x0 + 15*x1 + 11*x2 + 4*x3 >= 24)
    model.addConstr(-9*x2 + x3 >= 0)
    model.addConstr(6*x0 + 18*x1 + 18*x2 <= 72)
    model.addConstr(6*x0 + 18*x1 + 21*x3 <= 74)
    model.addConstr(18*x1 + 18*x2 + 21*x3 <= 50)
    model.addConstr(6*x0 + 18*x2 + 21*x3 <= 158)
    model.addConstr(12*x0 + 15*x1 <= 102)
    model.addConstr(15*x1 + 11*x2 <= 155)
    model.addConstr(12*x0 + 11*x2 + 4*x3 <= 116)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Apple Pies: ", x0.varValue)
        print("Apples: ", x1.varValue)
        print("Oreos: ", x2.varValue)
        print("Bowls of Cereal: ", x3.varValue)
    else:
        print("No optimal solution found")

solve_optimization_problem()
