
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="fruit_salads")
    x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="cantaloupes")


    # Set objective function
    m.setObjective(6*x0 + 2*x1, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(3*x0 + 15*x1 >= 57, "fiber_min")
    m.addConstr(11*x0 + 17*x1 >= 61, "protein_min")
    m.addConstr(1*x0 + 21*x1 >= 77, "fat_min")
    m.addConstr(-10*x0 + 2*x1 >= 0, "constraint4")
    m.addConstr(3*x0 + 15*x1 <= 285, "fiber_max")
    m.addConstr(11*x0 + 17*x1 <= 252, "protein_max")
    m.addConstr(1*x0 + 21*x1 <= 224, "fat_max")


    # Optimize model
    m.optimize()

    # Print results
    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('fruit_salads:', x0.x)
        print('cantaloupes:', x1.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')

