
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables - both are allowed to be non-integer
x0 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="fruit_salads")
x1 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="cantaloupes")

# Objective function
m.setObjective(6*x0 + 2*x1, GRB.MINIMIZE)

# Constraints
m.addConstr(3*x0 + 15*x1 >= 57, "fiber_min")
m.addConstr(3*x0 + 15*x1 <= 285, "fiber_max")
m.addConstr(11*x0 + 17*x1 >= 61, "protein_min")
m.addConstr(11*x0 + 17*x1 <= 216, "protein_max")
m.addConstr(1*x0 + 21*x1 >= 77, "fat_min")
m.addConstr(1*x0 + 21*x1 <= 211, "fat_max")
m.addConstr(-10*x0 + 2*x1 >= 0, "additional_constraint")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"fruit_salads = {x0.x}")
    print(f"cantaloupes = {x1.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
