
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="fruit_salads", lb=0)  # Assuming non-negative
    x2 = model.addVar(name="cantaloupes", lb=0)  # Assuming non-negative

    # Define the objective function
    model.setObjective(6 * x1 + 2 * x2, gurobi.GRB.MINIMIZE)

    # Define the constraints
    model.addConstr(3 * x1 + 15 * x2 >= 57, name="fiber_constraint")
    model.addConstr(11 * x1 + 17 * x2 >= 61, name="protein_constraint")
    model.addConstr(x1 + 21 * x2 >= 77, name="fat_constraint")
    model.addConstr(-10 * x1 + 2 * x2 >= 0, name="additional_constraint")
    model.addConstr(3 * x1 + 15 * x2 <= 285, name="fiber_upper_bound")
    model.addConstr(11 * x1 + 17 * x2 <= 216, name="protein_upper_bound")
    model.addConstr(x1 + 21 * x2 <= 211, name="fat_upper_bound")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Fruit Salads: {x1.varValue}")
        print(f"Cantaloupes: {x2.varValue}")
        print(f"Objective Function Value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
