
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("maximize_food_value")

    # Create variables
    black_beans = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="black_beans")
    cornichons = m.addVar(lb=0, vtype=GRB.INTEGER, name="cornichons")


    # Set objective function
    m.setObjective(2 * black_beans + 5 * cornichons, GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(20 * black_beans + 13 * cornichons >= 102, "tastiness_min")
    m.addConstr(25 * black_beans + 13 * cornichons >= 69, "sourness_min")
    m.addConstr(4 * black_beans - 4 * cornichons >= 0, "black_beans_cornichons_ratio")
    m.addConstr(20 * black_beans + 13 * cornichons <= 152, "tastiness_max")
    m.addConstr(25 * black_beans + 13 * cornichons <= 240, "sourness_max")


    # Optimize model
    m.optimize()

    # Print results
    if m.status == GRB.OPTIMAL:
        print(f"Optimal objective value: {m.objVal}")
        print(f"Black beans: {black_beans.x}")
        print(f"Cornichons: {cornichons.x}")
    elif m.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
