
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="black_beans")
x2 = m.addVar(vtype=GRB.INTEGER, name="cornichons")

# Set the objective function
m.setObjective(2*x1 + 5*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(20*x1 + 13*x2 >= 102, "tastiness_rating")
m.addConstr(25*x1 + 13*x2 >= 69, "sourness_index")
m.addConstr(4*x1 - 4*x2 >= 0, "mixed_constraint")
m.addConstr(20*x1 + 13*x2 <= 152, "max_tastiness_rating")
m.addConstr(25*x1 + 13*x2 <= 240, "max_sourness_index")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Black beans: {x1.x}")
    print(f"Cornichons: {x2.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
