
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()
    
    # Define variables
    x1 = model.addVar(name="black_beans", lb=0)  # No lower bound specified, assuming 0
    x2 = model.addVar(name="cornichons", lb=0, integrality=gurobi.GRB.INTEGER)  # Must be integer
    
    # Objective function
    model.setObjective(2*x1 + 5*x2, gurobi.GRB.MAXIMIZE)
    
    # Constraints
    model.addConstr(20*x1 + 13*x2 >= 102)
    model.addConstr(25*x1 + 13*x2 >= 69)
    model.addConstr(4*x1 - 4*x2 >= 0)
    model.addConstr(20*x1 + 13*x2 <= 152)
    model.addConstr(25*x1 + 13*x2 <= 240)
    
    # Solve the model
    model.optimize()
    
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Optimal solution found.")
        print(f"Black beans: {x1.varValue}")
        print(f"Cornichons: {x2.varValue}")
        print(f"Objective: {model.objVal}")
    elif model.status == gurobi.GRB.Status.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("The model has a non-optimal status.")

solve_optimization_problem()
