
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_model")

    # Create variables
    x0 = m.addVar(name="hours worked by Bobby")
    x1 = m.addVar(name="hours worked by Paul")
    x2 = m.addVar(name="hours worked by George", vtype=gp.GRB.INTEGER)


    # Set objective function
    m.setObjective(7.06 * x0 + 2.87 * x1 + 5.24 * x2, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(18.72 * x0 + 11.73 * x1 >= 61)
    m.addConstr(18.72 * x0 + 11.73 * x1 + 13.63 * x2 >= 61)
    m.addConstr(0.15 * x1 + 1.88 * x2 >= 49)
    m.addConstr(21.45 * x0 + 0.15 * x1 >= 25)
    m.addConstr(21.45 * x0 + 0.15 * x1 + 1.88 * x2 >= 25)
    m.addConstr(5.23 * x0 + 17.87 * x1 >= 39)
    m.addConstr(17.87 * x1 + 20.72 * x2 >= 64)
    m.addConstr(5.23 * x0 + 20.72 * x2 >= 56)
    m.addConstr(5.23 * x0 + 17.87 * x1 + 20.72 * x2 >= 56)
    m.addConstr(21.45 * x0 + 0.15 * x1 <= 87)
    m.addConstr(0.15 * x1 + 1.88 * x2 <= 97)



    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
