
import gurobi

# Define the model
model = gurobi.Model()

# Define the variables
x0 = model.addVar(name="x0", lb=0)  # hours worked by Bobby
x1 = model.addVar(name="x1", lb=0)  # hours worked by Paul
x2 = model.addVar(name="x2", lb=0, vtype=gurobi.GRB.INTEGER)  # hours worked by George

# Define the objective function
model.setObjective(7.06 * x0 + 2.87 * x1 + 5.24 * x2, gurobi.GRB.MINIMIZE)

# Add constraints
model.addConstr(18.72 * x0 <= 206)
model.addConstr(21.45 * x0 <= 194)
model.addConstr(5.23 * x0 <= 232)
model.addConstr(11.73 * x1 <= 206)
model.addConstr(0.15 * x1 <= 194)
model.addConstr(17.87 * x1 <= 232)
model.addConstr(13.63 * x2 <= 206)
model.addConstr(1.88 * x2 <= 194)
model.addConstr(20.72 * x2 <= 232)
model.addConstr(18.72 * x0 + 11.73 * x1 >= 61)
model.addConstr(18.72 * x0 + 11.73 * x1 + 13.63 * x2 >= 61)
model.addConstr(0.15 * x1 + 1.88 * x2 >= 49)
model.addConstr(21.45 * x0 + 0.15 * x1 >= 25)
model.addConstr(21.45 * x0 + 0.15 * x1 + 1.88 * x2 >= 25)
model.addConstr(5.23 * x0 + 17.87 * x1 >= 39)
model.addConstr(17.87 * x1 + 20.72 * x2 >= 64)
model.addConstr(5.23 * x0 + 20.72 * x2 >= 56)
model.addConstr(5.23 * x0 + 17.87 * x1 + 20.72 * x2 >= 56)
model.addConstr(21.45 * x0 + 0.15 * x1 <= 87)
model.addConstr(0.15 * x1 + 1.88 * x2 <= 97)

# Solve the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objval)
    print("Hours worked by Bobby: ", x0.varValue)
    print("Hours worked by Paul: ", x1.varValue)
    print("Hours worked by George: ", x2.varValue)
else:
    print("The model is infeasible")
