
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="protein_bars")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="bagged_salads")
x3 = m.addVar(vtype=GRB.INTEGER, name="granola_bars")
x4 = m.addVar(vtype=GRB.CONTINUOUS, name="hamburgers")
x5 = m.addVar(vtype=GRB.INTEGER, name="slices_of_pizza")

# Set the objective function
m.setObjective(4*x1**2 + 2*x2**2 - x3 + 3*x4 + 2*x5, GRB.MAXIMIZE)

# Add constraints to the model
m.addConstr(3*x1 + 2*x2 >= 10)
m.addConstr(x1 + x2 <= 15)
m.addConstr(x3 >= 5)
m.addConstr(x4 <= 20)
m.addConstr(x5 >= 0) # implicit constraint that x5 is non-negative
m.addConstr(x1 + x3 + x5 <= 30)
m.addConstr(2*x2 + 3*x4 >= 25)
m.addConstr(x1 - x2 <= 10)
m.addConstr(x3 + x4 <= 15)
m.addConstr(x2 + x5 >= 20)
m.addConstr(x1 + x4 <= 25)
m.addConstr(2*x1 + 3*x3 >= 30)
m.addConstr(x2 + x4 + x5 <= 35)
m.addConstr(x1 - x3 <= 15)
m.addConstr(x2 + x3 + x4 >= 40)
m.addConstr(x1 + x5 <= 20)
m.addConstr(3*x1 + 2*x3 <= 50)

# Solve the model
m.optimize()
