
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimize_work_hours")

    # Create variables
    hank_hours = m.addVar(lb=0, name="hank_hours")
    mary_hours = m.addVar(lb=0, name="mary_hours")
    bobby_hours = m.addVar(lb=0, name="bobby_hours")


    # Set objective function
    m.setObjective(6 * hank_hours + 7 * mary_hours + 2 * bobby_hours, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(23.13 * hank_hours + 19.71 * mary_hours + 7.57 * bobby_hours >= 51, "c0")
    m.addConstr(2 * hank_hours - 3 * bobby_hours >= 0, "c1")
    m.addConstr(23.13 * hank_hours + 7.57 * bobby_hours <= 114, "c2")
    m.addConstr(19.71 * mary_hours + 7.57 * bobby_hours <= 109, "c3")
    m.addConstr(23.13 * hank_hours + 19.71 * mary_hours + 7.57 * bobby_hours <= 109, "c4")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Optimal objective: %g' % m.objVal)
        print('Hank hours: %g' % hank_hours.x)
        print('Mary hours: %g' % mary_hours.x)
        print('Bobby hours: %g' % bobby_hours.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
