
from gurobipy import *

# Create a new model
m = Model("WorkHoursOptimization")

# Define the variables
x1 = m.addVar(name="hours_worked_by_Hank", lb=0)
x2 = m.addVar(name="hours_worked_by_Mary", lb=0)
x3 = m.addVar(name="hours_worked_by_Bobby", lb=0)

# Set the objective function
m.setObjective(6*x1 + 7*x2 + 2*x3, GRB.MAXIMIZE)

# Add constraints
m.addConstr(23.13*x1 + 19.71*x2 + 7.57*x3 >= 51, name="total_cost_at_least_51")
m.addConstr(2*x1 - 3*x3 >= 0, name="hank_bobby_constraint")
m.addConstr(23.13*x1 + 7.57*x3 <= 114, name="hank_bobby_total_at_most_114")
m.addConstr(19.71*x2 + 7.57*x3 <= 109, name="mary_bobby_total_at_most_109")
m.addConstr(23.13*x1 + 19.71*x2 + 7.57*x3 <= 109, name="total_cost_at_most_109")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Hank: {x1.x}")
    print(f"Hours worked by Mary: {x2.x}")
    print(f"Hours worked by Bobby: {x3.x}")
else:
    print("No optimal solution found")
