
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='hours_worked_by_Hank', lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
    x2 = model.addVar(name='hours_worked_by_Mary', lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
    x3 = model.addVar(name='hours_worked_by_Bobby', lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)

    # Define the objective function
    model.setObjective(6 * x1 + 7 * x2 + 2 * x3, gurobi.GRB.MAXIMIZE)

    # Define the constraints
    model.addConstr(23.13 * x1 + 19.71 * x2 + 7.57 * x3 >= 51)
    model.addConstr(2 * x1 - 3 * x3 >= 0)
    model.addConstr(23.13 * x1 + 7.57 * x3 <= 114)
    model.addConstr(19.71 * x2 + 7.57 * x3 <= 109)
    model.addConstr(23.13 * x1 + 19.71 * x2 + 7.57 * x3 <= 109)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print('Objective: ', model.objVal)
        print('Hours worked by Hank: ', x1.x)
        print('Hours worked by Mary: ', x2.x)
        print('Hours worked by Bobby: ', x3.x)
    else:
        print('The model is infeasible')

solve_optimization_problem()
