
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
calcium = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="calcium")
vitamin_b5 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b5")
vitamin_b3 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b3")
fiber = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="fiber")
vitamin_a = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_a")


# Set objective function
m.setObjective(4 * calcium + 9 * vitamin_b5 + 7 * vitamin_b3 + 2 * fiber + 1 * vitamin_a, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(3 * calcium + 4 * vitamin_b5 + 8 * vitamin_b3 + 8 * fiber + 11 * vitamin_a <= 200, "r0")
m.addConstr(4 * vitamin_b5 + 8 * vitamin_b3 >= 33)
m.addConstr(8 * vitamin_b3 + 11 * vitamin_a >= 20)
m.addConstr(8 * fiber + 11 * vitamin_a >= 37)
m.addConstr(4 * vitamin_b5 + 8 * fiber >= 26)
m.addConstr(3 * calcium + 8 * fiber >= 27)
m.addConstr(3 * calcium + 11 * vitamin_a >= 19)

# ... (add remaining constraints similarly)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print("Optimization ended with status %d" % m.status)

