
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=-gurobi.GRB.INFINITY, name="calcium")
    x2 = model.addVar(lb=-gurobi.GRB.INFINITY, name="vitamin_B5")
    x3 = model.addVar(lb=-gurobi.GRB.INFINITY, name="vitamin_B3")
    x4 = model.addVar(lb=-gurobi.GRB.INFINITY, name="fiber")
    x5 = model.addVar(lb=-gurobi.GRB.INFINITY, name="vitamin_A")

    # Objective function
    model.setObjective(4*x1 + 9*x2 + 7*x3 + 2*x4 + x5, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(3*x1 <= 200)
    model.addConstr(4*x2 <= 200)
    model.addConstr(8*x3 <= 200)
    model.addConstr(8*x4 <= 200)
    model.addConstr(11*x5 <= 200)

    model.addConstr(4*x2 + 8*x3 >= 33)
    model.addConstr(8*x3 + 11*x5 >= 20)
    model.addConstr(8*x4 + 11*x5 >= 37)
    model.addConstr(4*x2 + 8*x4 >= 26)
    model.addConstr(3*x1 + 8*x4 >= 27)
    model.addConstr(3*x1 + 11*x5 >= 19)
    model.addConstr(4*x2 + 8*x3 + 11*x5 >= 21)
    model.addConstr(8*x3 + 8*x4 + 11*x5 >= 21)
    model.addConstr(3*x1 + 8*x3 + 8*x4 >= 21)
    model.addConstr(3*x1 + 4*x2 + 8*x4 >= 21)
    model.addConstr(3*x1 + 4*x2 + 8*x3 >= 21)
    model.addConstr(3*x1 + 4*x2 + 11*x5 >= 21)
    model.addConstr(3*x1 + 8*x3 + 11*x5 >= 21)
    model.addConstr(4*x2 + 8*x4 + 11*x5 >= 21)
    model.addConstr(4*x2 + 8*x3 + 8*x4 >= 21)
    model.addConstr(3*x1 + 8*x4 + 11*x5 >= 21)

    model.addConstr(4*x2 + 8*x3 + 11*x5 >= 23)
    model.addConstr(8*x3 + 8*x4 + 11*x5 >= 23)
    model.addConstr(3*x1 + 8*x3 + 8*x4 >= 23)
    model.addConstr(3*x1 + 4*x2 + 8*x4 >= 23)
    model.addConstr(3*x1 + 4*x2 + 8*x3 >= 23)
    model.addConstr(3*x1 + 4*x2 + 11*x5 >= 23)
    model.addConstr(3*x1 + 8*x3 + 11*x5 >= 23)
    model.addConstr(4*x2 + 8*x4 + 11*x5 >= 23)
    model.addConstr(4*x2 + 8*x3 + 8*x4 >= 23)
    model.addConstr(3*x1 + 8*x4 + 11*x5 >= 23)

    model.addConstr(4*x2 + 8*x3 + 11*x5 >= 27)
    model.addConstr(8*x3 + 8*x4 + 11*x5 >= 27)
    model.addConstr(3*x1 + 8*x3 + 8*x4 >= 27)
    model.addConstr(3*x1 + 4*x2 + 8*x4 >= 27)
    model.addConstr(3*x1 + 4*x2 + 8*x3 >= 27)
    model.addConstr(3*x1 + 4*x2 + 11*x5 >= 27)
    model.addConstr(3*x1 + 8*x3 + 11*x5 >= 27)
    model.addConstr(4*x2 + 8*x4 + 11*x5 >= 27)
    model.addConstr(4*x2 + 8*x3 + 8*x4 >= 27)
    model.addConstr(3*x1 + 8*x4 + 11*x5 >= 27)

    model.addConstr(4*x2 + 8*x3 + 11*x5 >= 35)
    model.addConstr(8*x3 + 8*x4 + 11*x5 >= 35)
    model.addConstr(3*x1 + 8*x3 + 8*x4 >= 35)
    model.addConstr(3*x1 + 4*x2 + 8*x4 >= 35)
    model.addConstr(3*x1 + 4*x2 + 8*x3 >= 35)
    model.addConstr(3*x1 + 4*x2 + 11*x5 >= 35)
    model.addConstr(3*x1 + 8*x3 + 11*x5 >= 35)
    model.addConstr(4*x2 + 8*x4 + 11*x5 >= 35)
    model.addConstr(4*x2 + 8*x3 + 8*x4 >= 35)
    model.addConstr(3*x1 + 8*x4 + 11*x5 >= 35)

    model.addConstr(4*x2 + 8*x4 <= 59)
    model.addConstr(8*x3 + 11*x5 <= 47)
    model.addConstr(3*x1 + 11*x5 <= 133)
    model.addConstr(3*x1 + 8*x4 <= 159)
    model.addConstr(8*x4 + 11*x5 <= 187)
    model.addConstr(4*x2 + 11*x5 <= 153)
    model.addConstr(8*x3 + 8*x4 <= 106)
    model.addConstr(3*x1 + 4*x2 <= 157)
    model.addConstr(3*x1 + 8*x3 <= 132)
    model.addConstr(3*x1 + 8*x3 + 8*x4 <= 163)
    model.addConstr(4*x2 + 8*x3 + 8*x4 <= 123)
    model.addConstr(3*x1 + 4*x2 + 8*x4 <= 50)
    model.addConstr(8*x3 + 8*x4 + 11*x5 <= 160)
    model.addConstr(3*x1 + 4*x2 + 11*x5 <= 183)
    model.addConstr(3*x1 + 4*x2 + 8*x3 <= 129)
    model.addConstr(3*x1 + 4*x2 + 8*x3 + 8*x4 + 11*x5 <= 129)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Calcium: ", x1.varValue)
        print("Vitamin B5: ", x2.varValue)
        print("Vitamin B3: ", x3.varValue)
        print("Fiber: ", x4.varValue)
        print("Vitamin A: ", x5.varValue)
    else:
        print("No solution found")

solve_optimization_problem()
