
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("PlantOptimization")

    # Create variables
    boxwoods = m.addVar(vtype=gp.GRB.INTEGER, name="boxwoods")
    roses = m.addVar(vtype=gp.GRB.INTEGER, name="roses")
    begonias = m.addVar(vtype=gp.GRB.INTEGER, name="begonias")

    # Set objective function
    m.setObjective(8.66 * boxwoods + 8.39 * roses + 3.72 * begonias, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(8.65 * boxwoods + 1.12 * roses + 0.8 * begonias >= 28 * 144, "PlantingSpaceMin")
    m.addConstr(9.06 * boxwoods + 5.81 * begonias >= 32, "ResilienceBoxwoodsBegoniasMin")
    m.addConstr(6.61 * roses + 5.81 * begonias >= 18, "ResilienceRosesBegoniasMin")
    m.addConstr(9.06 * boxwoods + 6.61 * roses + 5.81 * begonias >= 20, "ResilienceTotalMin")
    m.addConstr(8.65 * boxwoods + 0.8 * begonias <= 135 * 144, "PlantingSpaceBoxwoodsBegoniasMax")
    m.addConstr(1.12 * roses + 0.8 * begonias <= 68 * 144, "PlantingSpaceRosesBegoniasMax")
    m.addConstr(8.65 * boxwoods + 1.12 * roses <= 128 * 144, "PlantingSpaceBoxwoodsRosesMax")
    m.addConstr(8.65 * boxwoods + 1.12 * roses + 0.8 * begonias <= 67 * 144, "PlantingSpaceTotalMax")
    m.addConstr(6.61 * roses + 5.81 * begonias <= 94, "ResilienceRosesBegoniasMax")
    m.addConstr(9.06 * boxwoods + 6.61 * roses <= 35, "ResilienceBoxwoodsRosesMax")
    m.addConstr(9.06 * boxwoods + 6.61 * roses + 5.81 * begonias <= 35, "ResilienceTotalMax")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
