
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="boxwoods", vtype=gurobi.GRB.INTEGER)
x1 = m.addVar(name="roses", vtype=gurobi.GRB.INTEGER)
x2 = m.addVar(name="begonias", vtype=gurobi.GRB.INTEGER)

# Objective function
m.setObjective(8.66 * x0 + 8.39 * x1 + 3.72 * x2, gurobi.GRB.MAXIMIZE)

# Constraints
m.addConstr(8.65 * x0 + 1.12 * x1 + 0.8 * x2 >= 28 * 144)  # Planting space minimum
m.addConstr(9.06 * x0 + 5.81 * x2 >= 32)  # Resilience index minimum for boxwoods and begonias
m.addConstr(6.61 * x1 + 5.81 * x2 >= 18)  # Resilience index minimum for roses and begonias
m.addConstr(9.06 * x0 + 6.61 * x1 + 5.81 * x2 >= 20)  # Total resilience index minimum
m.addConstr(8.65 * x0 + 0.8 * x2 <= 135 * 144)  # Boxwoods and begonias maximum planting space
m.addConstr(1.12 * x1 + 0.8 * x2 <= 68 * 144)  # Roses and begonias maximum planting space
m.addConstr(8.65 * x0 + 1.12 * x1 <= 128 * 144)  # Boxwoods and roses maximum planting space
m.addConstr(8.65 * x0 + 1.12 * x1 + 0.8 * x2 <= 67 * 144)  # Total maximum planting space
m.addConstr(6.61 * x1 + 5.81 * x2 <= 94)  # Resilience index maximum for roses and begonias
m.addConstr(9.06 * x0 + 6.61 * x1 <= 35)  # Resilience index maximum for boxwoods and roses
m.addConstr(9.06 * x0 + 6.61 * x1 + 5.81 * x2 <= 35)  # Total resilience index maximum

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Boxwoods: ", x0.varValue)
    print("Roses: ", x1.varValue)
    print("Begonias: ", x2.varValue)
else:
    print("The model is infeasible")
