
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    x0 = model.addVar(vtype=gp.GRB.CONTINUOUS, name="x0")  # hours worked by Dale
    x1 = model.addVar(vtype=gp.GRB.CONTINUOUS, name="x1")  # hours worked by Peggy
    x2 = model.addVar(vtype=gp.GRB.CONTINUOUS, name="x2")  # hours worked by Bill


    # Set objective function
    model.setObjective(1*x0 + 3*x1 + 6*x2, gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(12*x1 + 11*x2 >= 24)
    model.addConstr(20*x0 + 12*x1 >= 36)
    model.addConstr(20*x0 + 12*x1 + 11*x2 >= 36)
    model.addConstr(13*x0 + 18*x2 >= 15)
    model.addConstr(15*x1 + 18*x2 >= 33)
    model.addConstr(13*x0 + 15*x1 + 18*x2 >= 23)
    model.addConstr(10*x1 + 15*x2 >= 32)
    model.addConstr(20*x0 + 10*x1 >= 23)
    model.addConstr(20*x0 + 10*x1 + 15*x2 >= 24)
    model.addConstr(-10*x1 + 10*x2 >= 0)
    model.addConstr(13*x0 + 15*x1 <= 103)
    model.addConstr(13*x0 + 18*x2 <= 66)
    model.addConstr(13*x0 + 15*x1 + 18*x2 <= 115)
    model.addConstr(10*x1 + 15*x2 <= 95)
    model.addConstr(20*x0 + 15*x2 <= 42)


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == gp.GRB.INFEASIBLE:
        print('The problem is infeasible.')


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
