
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name='x0', lb=0)  # hours worked by Dale
    x1 = model.addVar(name='x1', lb=0)  # hours worked by Peggy
    x2 = model.addVar(name='x2', lb=0)  # hours worked by Bill

    # Define the objective function
    model.setObjective(x0 + 3 * x1 + 6 * x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(12 * x1 + 11 * x2 >= 24)
    model.addConstr(20 * x0 + 12 * x1 >= 36)
    model.addConstr(20 * x0 + 12 * x1 + 11 * x2 >= 36)
    model.addConstr(13 * x0 + 18 * x2 >= 15)
    model.addConstr(15 * x1 + 18 * x2 >= 33)
    model.addConstr(13 * x0 + 15 * x1 + 18 * x2 >= 23)
    model.addConstr(10 * x1 + 15 * x2 >= 32)
    model.addConstr(20 * x0 + 10 * x1 >= 23)
    model.addConstr(20 * x0 + 10 * x1 + 15 * x2 >= 24)
    model.addConstr(-10 * x1 + 10 * x2 >= 0)
    model.addConstr(13 * x0 + 15 * x1 <= 103)
    model.addConstr(13 * x0 + 18 * x2 <= 66)
    model.addConstr(13 * x0 + 15 * x1 + 18 * x2 <= 115)
    model.addConstr(10 * x1 + 15 * x2 <= 95)
    model.addConstr(20 * x0 + 15 * x2 <= 42)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Objective: ', model.objval)
        print('x0: ', x0.x)
        print('x1: ', x1.x)
        print('x2: ', x2.x)
    else:
        print('The model is infeasible')

solve_optimization_problem()
