
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("nutrition_optimization")

    # Create variables
    vitamin_e = m.addVar(vtype=gp.GRB.INTEGER, name="vitamin_e")
    calcium = m.addVar(vtype=gp.GRB.CONTINUOUS, name="calcium")
    vitamin_c = m.addVar(vtype=gp.GRB.CONTINUOUS, name="vitamin_c")


    # Set objective function
    m.setObjective(5*vitamin_e + 1*calcium + 8*vitamin_c, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(24*vitamin_e + 29*calcium + 6*vitamin_c >= 45, "c0")
    m.addConstr(28*vitamin_e + 25*calcium <= 106, "c1")
    m.addConstr(25*calcium + 13*vitamin_c <= 70, "c2")
    m.addConstr(28*vitamin_e + 25*calcium + 13*vitamin_c <= 70, "c3")
    m.addConstr(29*calcium + 18*vitamin_c <= 148, "c4")
    m.addConstr(19*vitamin_e + 29*calcium <= 103, "c5")
    m.addConstr(19*vitamin_e + 29*calcium + 18*vitamin_c <= 103, "c6")
    m.addConstr(24*vitamin_e + 29*calcium <= 137, "c7")
    m.addConstr(24*vitamin_e + 6*vitamin_c <= 166, "c8")
    m.addConstr(29*calcium + 6*vitamin_c <= 192, "c9")
    m.addConstr(24*vitamin_e + 29*calcium + 6*vitamin_c <= 192, "c10")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('vitamin_e: %g' % vitamin_e.x)
        print('calcium: %g' % calcium.x)
        print('vitamin_c: %g' % vitamin_c.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
